function [x_axis,y_axis,z_axis] = get_ibias_vg
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the current
prompt_current = 'enter the current module amplification';
dlgtitle_current = 'Input';
user_val_current = inputdlg(prompt_current,dlgtitle_current);
current_val = str2num(user_val_current{1});

%% ask for the voltage
prompt_voltage = 'enter the Vmeasure module amplification';
dlgtitle_voltage = 'Input';
user_val_voltage = inputdlg(prompt_voltage,dlgtitle_voltage);
voltage_val = str2num(user_val_voltage{1});


%% ask for the gate voltage
prompt_gate_voltage = 'enter the amplification for the gate voltage';
dlgtitle_gate_voltage = 'Input';
user_val_gate_voltage = inputdlg(prompt_gate_voltage,dlgtitle_gate_voltage);
gate_voltage_val = str2num(user_val_gate_voltage{1});


%% Reading the size of Ibias
str_Ibias = char(file.textdata(6));
str_split = strsplit(str_Ibias);
size_Ibias = str2num(str_split{3});

%% Getting Ibias values
Ibias = file.data(1:size_Ibias,1)*current_val;


%% Reading the size of Vg
str_Vg = char(file.textdata(12));
str_split_Vg = strsplit(str_Vg);
size_Vg = str2num(str_split_Vg{3});

actual_size_Vg=size(file.data(:,1))/size_Ibias;%in case you stopped the scan in the middle

%% Getting the gate voltage and measured Voltage values
r=1;
for i=1:actual_size_Vg(1)
    Vg(i)=file.data(r,2);
    r=r+size_Ibias;

end

%% Getting measured Voltage values
s=1;
Vmeasure = zeros(actual_size_Vg(1),size_Ibias);
for i=1:actual_size_Vg(1)
    Vmeasure(i,1:size_Ibias)=file.data(s:s+size_Ibias-1,4)*voltage_val;
    s=s+size_Ibias;
end

%% calculating the differential resistance in Ohms
dVdI = zeros(actual_size_Vg(1),size_Ibias);
for i=1:actual_size_Vg(1)
    for j=2:size_Ibias-1
        dVdI(i,j) = (Vmeasure(i,j+1)-Vmeasure(i,j-1))/(Ibias(j+1)-Ibias(j-1));
    end
end

figure;
x_axis = Vg*gate_voltage_val;
y_axis = Ibias(2:end-1)*10^9; %in nA
z_axis = transpose(dVdI(:,2:end-1));
figure1 = pcolor(x_axis,Ibias(2:end-1)*10^9,transpose(dVdI(:,end-1:-1:2))/1000);
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
%max_value = max(max(transpose(dVdI(:,2:end-1))));
%caxis([0 max_value])
%caxis([0 1.01*10^4])
% cl.Ticks = [0 2000 4000 6000 8000 10000];
% cl.TickLabels = {'0','2000','4000','6000','8000','10000'};
cl.Label.String = 'R (k\Omega)';
xlabel('$V_{g}(V)$','Interpreter','latex')
ylabel('$I_{bias}(nA)$','Interpreter','latex');

end